#include "../bdtypes.h"
#include "../bdfunc.h"
#include "../bdglobal.h"

#define FOND_Z (1.f)
static GrVertex Fond1 = {0.f,0.f,FOND_Z,  255,128,128,   0,128.f,1.f/FOND_Z,{1.f,1.f, 1.f/FOND_Z}};
static GrVertex Fond2 = {640.f,0,FOND_Z,   128,255,128,   0,128.f,1.f/FOND_Z,{255.f/FOND_Z,0,1.f/300.f}};
static GrVertex Fond3 = {640.,480.,FOND_Z,   64,64,192,   0,128.f,1.f/FOND_Z,{255.f/FOND_Z,255.f/FOND_Z,1.f/FOND_Z}};
static GrVertex Fond4 = {0,480.,FOND_Z,   64,64,192,   0,128.f,1.f/FOND_Z,{1.f,255.f/FOND_Z,1.f/FOND_Z}};

static int *pBumpedX, *pBumpedY;

void LInit_Bump2()
{
	int Cpt1, Cpt2;

	WORD *pTmp = (WORD*)malloc(sizeof(WORD)*65536);
	pBumpedX = (int*)malloc(sizeof(int)*256*256);
	pBumpedY = (int*)malloc(sizeof(int)*256*256);

	for(Cpt1=0;Cpt1<65536;Cpt1++)
	{
		pTmp[Cpt1] = ((g_PicLogo[Cpt1]&31)*8
					+ (((g_PicLogo[Cpt1]&(31<<6))*8)>>6)
					+ (((g_PicLogo[Cpt1]&(31<<11))*8)>>11)) /3;
	}

	for(Cpt2=1;Cpt2<255;Cpt2++)
	{
		for(Cpt1=1;Cpt1<255;Cpt1++)
		{
			pBumpedX[Cpt1+Cpt2*256] = pTmp[Cpt1-1+Cpt2*256] - pTmp[Cpt1+1+Cpt2*256];
			pBumpedY[Cpt1+Cpt2*256] = pTmp[Cpt1+(Cpt2-1)*256] - pTmp[Cpt1+(Cpt2+1)*256];
		}
	}

	free(pTmp);

	PrepareTextureFromArray(g_PicLogo, 256, 256, &g_TextureLogo);
}

void QInit_Bump2()
{
	grDepthBufferMode(GR_DEPTHBUFFER_WBUFFER);
	grDepthBufferFunction(GR_CMP_ALWAYS);
	grAlphaCombine(GR_COMBINE_FUNCTION_BLEND_OTHER, GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_NONE, GR_COMBINE_OTHER_CONSTANT, FXFALSE);
	grAlphaBlendFunction(GR_BLEND_ONE, GR_BLEND_ONE,
							GR_BLEND_ZERO, GR_BLEND_ZERO);
	grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
					GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
	grCullMode(GR_CULL_DISABLE);
	grFogMode(GR_FOG_DISABLE);

	grChromakeyMode(GR_CHROMAKEY_DISABLE);
	g_demostate.ClearColor = 0;

	DownloadTexture(&g_TextureLogo);

	g_TextureBuff.info.format = GR_TEXFMT_INTENSITY_8;
}

void Effect_Bump2()
{
	WORD Img1;
	int *pX, *pY;
	int PosX, PosY;
	int lx, ly;
	BYTE *pBuffTmp;
	int newX, newY;
	int Cpt1, Cpt2;
	
	Img1 = (unsigned short)g_demostate.TickInEffect/10;

	PosX = (int)(127.f*(float)cos(Img1/40.f) + 128.f);
	PosY = (int)(127.f*(float)sin(Img1/34.f) + 128.f);

	pX = pBumpedX+256;
	pY = pBumpedY+256;

	ly = 1 - PosY;

	pBuffTmp = (BYTE*)g_FrameBuf3d + 257;
	for(Cpt2=1;Cpt2<255;Cpt2++)
	{
		lx = 1 - PosX;
		for(Cpt1=1;Cpt1<255;Cpt1++)
		{	
			newX = 127-abs(*(pX++)-lx);
			if (newX<0)
				newX = 0;
			newY = 127-abs(*(pY++)-ly);
			if (newY<0)
				newY = 0;
			*(pBuffTmp++) = (newX*newY)/64;
			lx++;
		}
		pX += 2;
		pY += 2;
		pBuffTmp += 2;
		ly++;
		lx -= 254;
	}

	grTexDownloadMipMap(g_TextureBuff.tmu, g_TextureBuff.start,
						g_TextureBuff.evenOdd, &g_TextureBuff.info);

	SelectTexture(g_TextureLogo);

	grDrawTriangle(&Fond1, &Fond2, &Fond3);
	grDrawTriangle(&Fond3, &Fond4, &Fond1);

	SelectTexture(g_TextureBuff);
	grDrawTriangle(&Fond1, &Fond2, &Fond3);
	grDrawTriangle(&Fond3, &Fond4, &Fond1);
}

void ByeBye_Bump2()
{


}
